/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astrocoo;
import cds.astro.Astropos;
import cds.astro.FK5;
import cds.astro.ICRS;

public class Test {
    public static void test() {
        Astropos astropos = new Astropos(ICRS.create());
        astropos.set(12.3455, 5.6789);
        astropos.setEditing(Astrocoo.editingOptions("s"));
        astropos.convertTo(new FK5(2000.0, 2000.0));
        System.out.println(astropos.toString());
    }

    public static void test2() {
        String string = "83.29664986501 +82.77205709857";
        try {
            ICRS iCRS = new ICRS(2015.5);
            iCRS.precision = (byte)16;
            ICRS iCRS2 = ICRS.create();
            iCRS2.precision = (byte)16;
            Astropos astropos = new Astropos(iCRS);
            astropos.set(string);
            Astropos astropos2 = new Astropos(iCRS);
            astropos2.set(string);
            astropos2.setProperMotion(2038.341, -1663.726);
            System.out.println("in(J2015.5)= " + astropos2.toString("d"));
            astropos2.convertTo(iCRS2);
            System.out.println("out(J2000)= " + astropos2.toString("d"));
            Astropos astropos3 = new Astropos(iCRS2);
            astropos3.set(astropos2.getLon(), astropos2.getLat());
            astropos3.setProperMotion(astropos2.getProperMotionLon(), astropos2.getProperMotionLat());
            astropos3.convertTo(iCRS);
            System.out.println(">>out(J2015.5)= " + astropos3.toString("d"));
            System.out.println(">>should be>> " + astropos.toString("d"));
            System.out.println(">>distance mas>> " + Astrocoo.distance(astropos3.getLon(), astropos3.getLat(), astropos.getLon(), astropos.getLat()) * 60.0 * 60.0 * 1000.0);
            System.out.println(">>distance mas>> " + Astrocoo.distance(astropos3.getLon(), astropos3.getLat(), astropos2.getLon(), astropos2.getLat()) * 60.0 * 60.0 * 1000.0);
            System.out.println("P PM: " + astropos3.getProperMotionLon() + " " + astropos3.getProperMotionLat());
            System.out.println("O PM: " + astropos2.getProperMotionLon() + " " + astropos2.getProperMotionLat());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void test3() {
        ICRS iCRS = new ICRS(2000.0);
        ICRS iCRS2 = new ICRS(2015.5);
        Astropos astropos = new Astropos(iCRS2);
        astropos.setPrecision(14);
        astropos.set(12.3455, 5.6789);
        if (!astropos.setErrorEllipse(1.0, 1.0, 0.5, 2015.5)) {
            System.out.println("Error setting error ellipse");
            return;
        }
        if (!astropos.setParallax(0.2439, Double.NaN)) {
            System.out.println("Error setting plx (and its error");
            return;
        }
        astropos.convertTo(iCRS);
        astropos.setEditing(Astrocoo.editingOptions("s"));
        System.out.println(astropos.toString());
    }

    public static void test4() {
        System.out.println("Test equality with only coordinates ?" + new Astropos(ICRS.create(), 12.3455, 5.6789).equals(new Astropos(ICRS.create(), 12.3455, 5.6789)));
    }

    public static void test5() {
        Astropos astropos = new Astropos(ICRS.create(), 12.3455, 5.6789);
        boolean bl = false;
        System.out.println("------ A ------");
        Astropos astropos2 = (Astropos)astropos.clone();
        System.out.println(astropos2.toString());
        astropos2.convertTo(new FK5(2000.0, 2020.0));
        System.out.println(astropos2.toString() + "\n");
        System.out.println("------ B ------");
        astropos2 = (Astropos)astropos.clone();
        bl = astropos2.setProperMotion(1000.0, 1000.0);
        System.out.println("Set PM after toString? " + bl);
        System.out.println(astropos2.toString() + "\n");
        if (bl) {
            System.out.println("\tShould be with PM 1000,1000\n");
        }
        System.out.println("------ C ------");
        astropos2 = (Astropos)astropos.clone();
        System.out.println(astropos2.toString());
        astropos2 = new Astropos(astropos2);
        bl = astropos2.setProperMotion(1000.0, 1000.0);
        System.out.println("Set PM after construct copy? " + bl);
        System.out.println(astropos2.toString() + "\n");
        if (bl) {
            System.out.println("\tShould be with PM 1000,1000\n");
        }
        System.out.println("------ D ------");
        astropos2 = (Astropos)astropos.clone();
        System.out.println(astropos2.toString());
        astropos2 = (Astropos)astropos2.clone();
        bl = astropos2.setProperMotion(1000.0, 1000.0);
        System.out.println("Set PM after clone of old Astropos ? " + bl);
        System.out.println(astropos2.toString() + "\n");
        if (bl) {
            System.out.println("\tShould be with PM 1000,1000\n");
        }
        System.out.println("------ E ------");
        astropos2 = (Astropos)astropos.clone();
        bl = astropos2.setProperMotion(1000.0, 1000.0);
        System.out.println("Set PM after clone of fresh Astropos ? " + bl);
        System.out.println(astropos2.toString());
        astropos2.convertTo(new FK5(2000.0, 2020.0));
        System.out.println(astropos2.toString());
        if (bl) {
            System.out.println("\tShould be with PM 1000,1000\n");
        }
    }

    public static void main(String[] stringArray) {
        Test.test5();
    }
}

